#modname "LA Nation: Ulm Reborn"
#description "Adds the LA nation New Ulm, Iron Faith Reborn. By Sombre."
#icon "./Ulm Reborn/logo.tga"
#version 1.4


------ The mod uses these new id slots

--Nation 75

--Weapons 690-3

--Armour 321

--Monsters 2978-2983 + 2300-2320

--Sites 990-3




-------- New Weapons

-- Sternhammer

#newweapon 690
#name "Sternhammer"
#twohanded
#magic
#dmg 7
#att 1
#def 0
#len 3
#sound 11
#rcost 10
#secondaryeffect 232
#end

-- White Hammer

#newweapon 691
#name "White Hammer"
#dt_holy
#magic
#armorpiercing
#dmg 9
#att 2
#def 1
#len 2
#sound 11
#rcost 10
#end


-- Spirit Hammers

#newweapon 692
#name "Spirit Hammers"
#ammo 1
#dt_holy
#att 0
#magic
#def 0
#armorpiercing
#dmg 16
#nostr
#flyspr 411 4
#explspr 10220
#nratt 10
#range 50
#rcost 10
#sound 24
#end

-- Absolver Hammer

#newweapon 693
#name "Absolver Hammer"
#magic
#dmg 9
#att 2
#def 1
#len 2
#sound 11
#rcost 10
#secondaryeffect 216
#end



-------- New Armour

#newarmor 321
#name "Whitesteel Plate of Ulm"
#type 5
#prot 23
#def -4
#enc 4
#rcost 35
#end


-------- Units


--PRETENDERS

--Lord of War

#newmonster 2317

#copyspr 1340

#copystats 1340

#restrictedgod 75
#end

--Forge Lord

#newmonster 2318
#copyspr 1230
#copystats 1230
#restrictedgod 75

#end

--Virtue

#newmonster 2319
#copyspr 215

#copystats 215

#restrictedgod 75

#end

--Sacred Statue

#newmonster 2320
#copyspr 472

#copystats 472

#restrictedgod 75
#end


--UNITS

--Penitent

#newmonster 2978
#copyspr 217
#name "Penitent"
#descr "The new faith offers all a chance for rebirth and many who have fallen from the path of righteousness flock to receive the blessing of the new god and his priests, joining a classless force in society known as the penitent. They make for rabid fighters and their devotion to the iron faith grants them impressive strength but they are not well protected or trained and do not have the lasting power of professional soldiers."
#str 11
#weapon "flail"
#hp 11
#holy
#mor 15
#mr 9
#att 9
#def 9
#ap 12
#prec 8
#enc 3
#gcost 10
#rcost 1
#mapmove 2
#size 2
#nametype 104
#end


--Emergent

#newmonster 2313
#copyspr 217
#name "Emergent"
#descr "The Emergent are Penitent newly released from an anchorite struck open in battle. Reborn into chaos and violence they are filled with fanatical devotion to the Iron Faith and are temporarily charged with spiritual energy lending them great strength and resilience."
#str 14
#weapon "flail"
#hp 15
#prot 5
#holy
#mor 99
#mr 9
#att 9
#def 9
#ap 12
#prec 8
#enc 3
#gcost 8
#rcost 1
#mapmove 2
#size 2
#nametype 104
#firstshape 2978
#end


-- Infantry of Ulm

#newmonster 2300
#copystats 73
#copyspr 73
#name "Infantry of Ulm"
#descr "Although blacksteel armour has become increasingly harder to manufacture since the Civil War the basic infantry of Ulm are still well armoured with heavy chainmail and are well protected from missile fire by their traditional tower shields. Their favoured weapon is the hammer, symbol of the will of the new god and their own iron faith."
#mr 8
#nametype 104
#end

-- Crossbow of Ulm

#newmonster 2301
#copystats 49
#copyspr 417
#name "Crossbow of Ulm"
#descr "The old arbalest design fell out of favour during the long years of the civil war as it took too much training and maintenance to be of use. Modern Ulmish missile support comes from rugged and easily repaired crossbows used by well armoured troops."
#str 11
#hp 12
#mr 8
#nametype 104
#end

-- Pike of Ulm

#newmonster 2302
#copystats 79
#copyspr 79
#name "Pike of Ulm"
#descr "Pike form defensive blocks in the Ulmish army which grind down the enemy and allow time for the priests and templars to smite their blackhearted foes."
#mr 8
#nametype 104
#end

-- Black Zweihander

#newmonster 2303
#copystats 1034
#spr1 "./Ulm Reborn/Black Zwei.tga"
#spr2 "./Ulm Reborn/Black Zwei2.tga"
#name "Black Zweihander"
#descr "These elite infantry are named after the massive two handed swords they wield in combat. They are the only troops in the regular Ulmish army who are granted the prized blacksteel armour and as such they are very well protected. Their only weakness is that they can tire out if drawn into a long grinding battle. They are therefore best used as heavy shock infantry."
#armor "full plate of ulm"
#mr 8
#gcost 15
#nametype 104
#end

-- Anchorite

#newmonster 2304
#copystats 76
#copyspr 76
#name "Anchorite"
#descr "Just as the Aufklarung saved Ulm from itself, so shall criminals, madmen and heretics be given the blessing of rebirth. Anchorites are blessed suits of blacksteel armour which have been animated by the Black Priests and into which a fallen individual is sealed. These suits then march to battle armed with great two handed warhammers, smiting the enemies of Ulm left and right. Though extremely resistant to damage, the anchorites are slow and the spells that animate them are easily disrupted; they are inevitably struck down, but when they fall the occupant is released and, thus reborn, battles on with great fervour. As a fusion of cold emotionless steel and raging devotion they epitomise modern Ulm. Anchorites require a member of the new Iron Clergy to direct them."
#holy
#inanimate
#magicbeing
#coldres 50
#fireres 50
#poisonres 50
#neednoteat
#hp 4
#ap 10
#mor 50
#mr 10
#enc 0
#str 15
#gcost 22
#secondshape 2313
#nametype 104
#startage 25
#maxage 80
#end

-- Black Templar

#newmonster 2305
#copystats 738
#copyspr 738
#descr "The elite order of the Black Knights was very nearly wiped out by the Civil War. The few that survived the years of continuous conflict were dispersed and found themselves working for one local lord or another as mercenaries or petty vassals. The glory and honour of their past order seemed lost forever, but all that was changed by the descent of the Aufklarung. The scattered knights felt a power pulling their very souls towards the capital and were unable to resist. They gathered at the Black Temple and as one they vowed to serve the new Iron Faith as the Black Templars."
#weapon "hammer"
#weapon "lance"
#weapon 56
#nametype 104
#end


-- Neugeboren Guard

#newmonster 2306
#copystats 66
#name "Neugeboren Guard"
#descr "The Neugeboren, or reborn, are an elite band of men who were once known as the Guardians. During the Civil War they fought incredibly hard and no matter what forces attempted to storm the citadel they held their positions. All hope that the siege might be broken in time was soon lost however and the Guardians began to starve. Their legendary morale began to crumble and dark thoughts began to invade their minds via the sharp claws of hunger. When all seemed lost the light of the Aufklarung descended and the Guardians were saved. The Civil War ended almost immediately and when the Guardians emerged it was clear they had become something greater than mere men. They had been reborn; even their ancestral blacksteel plate had changed to reflect their purity."
#spr1 "./Ulm Reborn/Reborn Guard.tga"
#spr2 "./Ulm Reborn/Reborn Guard2.tga"
#holy
#armor "whitesteel plate of ulm"
#mor 15
#gcost 42
#mr 10
#nametype 104
#end


-------- Commanders

-- Hammer of Ulm

#newmonster 2307
#copystats 114
#copyspr 114
#name "Hammer of Ulm"
#descr "The Hammers of Ulm are the most common commanders in the army. They are well respected, capable of leading many men in battle and have been granted coveted blacksteel plate armour."
#armor "full plate of ulm"
#standard 3
#nametype 104
#end

-- Neugeboren Lord

#newmonster 2308
#copystats 113
#name "Neugeboren Lord"
#descr "Though of crucial import to the new faith, the leaders of the Neugeboren have no priestly powers. They are, however, direct representatives of the new god and as such are granted physical prowess beyond that of mere mortals and an aura of valour that allows them to lead a great many men. Their presence on the battlefield not only inspires Ulmish soldiers to acts of great bravery but also greatly unsettles any enemies foolish enough to approach such a figure."
#spr1 "./Ulm Reborn/Reborn Lord.tga"
#spr2 "./Ulm Reborn/Reborn Lord2.tga"
#holy
#armor "whitesteel plate of ulm"
#hp 30
#str 14
#mor 18
#fear 0
#awe 1
#mr 11
#standard 15
#gcost 170
#expertleader
#maxage 100
#nametype 104
#end

-- Black Acolyte

#newmonster 2309
#copystats 739
#copyspr 739
#descr "The Iron Faith of Ulm was initially a powerful cult enforcing perceived justice during the Civil War. When the Aufklarung brought a sudden end to the war the cult realised their full potential and became shepherds and guardians of Ulm. Their rule is absolute and all magical practice outside of the faith is banned. Acolytes serve as the rank and file of the Iron Faith; they do not have the authority to gather forces of penitent, but they are trained to infiltrate enemy lands and spread the will of the awakening god."
#stealthy 0
#gcost 40
#poorleader
#poormagicleader
#nametype 104
#end

-- Black Priest

#newmonster 2310
#copystats 740
#copyspr 740
#descr "The Iron Faith of Ulm was initially a powerful cult meting out perceived justice during the Civil War. When the Aufklarung brought a sudden end to the war the cult realised their full potential and became shepherds and guardians of Ulm. Their rule is absolute and all magical practice outside of the faith is banned. The more powerful Black Priests have some skills in Earth magic and while in the Dominion of the awakening god are able to attract large groups penitent wishing to atone for their actions during the Civil War."
#domsummon2 "penitent"
#okleader
#okmagicleader
#custommagic 1024 30
#gcost 180
#nametype 104
#end

-- Hochmeister

#newmonster 2311
#copystats 1237
#copyspr 1237
#descr "Hochmeisters skilled commanders, warriors, priests and inquisitors trained to lead the Black Templars into battle. They are chosen from amongst the Templar primarily for their fanatical devotion to the Iron Faith and they are highly unlikely to retreat from battle."
#mor 18
#poormagicleader
#weapon "hammer"
#weapon "lance"
#weapon 56
#nametype 104
#end


-- White Priest

#newmonster 2979
#copystats 1646
#copyspr 477
#clearmagic
#clearmagic
#clearmagic
#clearmagic
#name "White Priest"
#descr "During the Civil War the highest leaders of the Iron Cult burdened the responsibility for the actions of their faith alone. When entire villages had to be purged to fend off the encroaching darkness it was they that bore the weight upon their souls. When the Aufklarung descended on Ulm many of them were driven mad and fled into the Black Forest, but some were able to overcome their guilt and were reborn as pristine symbols of spiritual fortitude. They stand apart from the Black Temple and are the true leaders of the new faith. They are powerful priests skilled in both traditional earth magic and the study of the heavens. Although they attract far less penitent than the more grounded Black Priests, it is only the White Priests that may call the Sternkind and only they who can draw on such strong faith as to be unaffected by realms drained of magic."
#hp 9
#mapmove 2
#ap 12
#mr 15
#mor 16
#str 10
#att 8
#def 8
#prec 11
#enc 3
#magicskill 8 3
#magicskill 3 3
#magicskill 4 1
#gcost 290
#holy
#summon1 "penitent"
#goodleader
#okmagicleader
#maxage 100
#startage 85
#awe 1
#nametype 104
#forgebonus 10
#custommagic 2048 15
#end


-- Hoch-Hammer

#newmonster 2982
#spr1 "./Ulm Reborn/Hoch-Hammer.tga"
#spr2 "./Ulm Reborn/Hoch-Hammer2.tga"
#name "Hoch-Hammer"
#descr "Hoch-Hammers are ordinary Black Templar who chose to take sacred hammers from the White Temple and swear an oath of wrath and judgement upon the dark and corrupted world around them. They lack the training that the Hochmeisters receive at the Black Temple but the sheer power of the white hammers they hold make them extremely formidable on the battlefield; they can hurl a swarm of spirit hammers which attract blasts of energy from the mantle of the Aufklarung. Their eyes glowing with sacred energy they strike down the enemies of the Iron Faith from near or far. Hoch-Hammers will never use weapons other than their hammer and shield."
#weapon "White Hammer"
#weapon "Spirit Hammers"
#weapon 56
#armor "Full plate of ulm"
#armor "Full helmet"
#armor "kite shield"
#mounted
#size 3
#mor 18
#mr 11
#enc 5
#prec 12
#att 14
#def 13
#str 14
#hp 25
#gcost 200
#rcost 1
#holy
#mapmove 2
#ap 18
#okleader
#standard 5
#nametype 104
#itemslots 13440
#end

-- White Acolyte

#newmonster 2314
#copystats 1646
#spr1 "./Ulm Reborn/White Acolyte.tga"
#spr2 "./Ulm Reborn/White Acolyte2.tga"
#clearmagic
#clearmagic
#clearmagic
#clearmagic
#name "White Acolyte"
#descr "The Aufklarung brought about not only peace, religious fervour and a strong sense of purpose in Ulm; it also instilled a thirst for knowledge amongst many and drew them to the White Temple to be trained as Acolytes. The White Acolytes spend their time studying tomes of knowledge long thought lost to the Civil War. They make excellent researchers and like the more powerful White Priests they are unaffected by the currents of traditional magic; even in magically drained lands they are entirely effective. Their focus on constant study and catalogue has left them physically weak and they are reluctant to travel long distances. They often have skill in astral and earth magics."
#hp 8
#mapmove 1
#ap 10
#mr 12
#mor 11
#str 9
#att 7
#def 7
#prec 9
#enc 3
#magicskill 8 1
#researchbonus 1
#gcost 100
#holy
#noleader
#maxage 65
#startage 50
#nametype 104
#custommagic 3072 100
#custommagic 3072 10
#end







--------------------------------------


-------- National Summons


-- Sternkind

#newmonster 2980
#spr1 "./Ulm Reborn/Sternkind.tga"
#spr2 "./Ulm Reborn/Sternkind2.tga"
#name "Sternkind"
#descr "Sternheld are souls granted form by the Aufklarung. Their virtuous actions during the Civil War have not been forgotten and they are revered by the Iron Faith; they alone span the gap between the world of man and iron and the heavenly realm of the Aufklarung. These sacred undead warriors carry hammers which release a blast of electrical energy when they strike their target."
#str 11
#att 12
#def 10
#hp 22
#mapmove 3
#enc 3
#prec 11
#ap 12
#flying
#prot 8
#mr 10
#mor 20
#gcost 20
#undead
#holy
#size 3
#shockres 50
#weapon "Sternhammer"
#maxage 900
#startage 10
#nametype 139
#end


-- Sternheld

#newmonster 2981
#spr1 "./Ulm Reborn/Sternheld.tga"
#spr2 "./Ulm Reborn/Sternheld2.tga"
#name "Sternheld"
#descr "Sternheld are the hands of the Aufklarung, spirit beings given form and considerable power who are often found commanding forces of lesser Sternkind. Their black and white wings represent the transitional state of their souls between the mire of the Civil War and the glory of the Aufklarung. They are naturally gifted in air and astral magic."
#undead
#holy
#hp 25
#str 12
#att 13
#def 11
#prot 8
#enc 3
#prec 11
#gcost 300
#flying
#mr 12
#magicskill 4 2
#magicskill 1 2
#mapmove 3
#ap 12
#mor 22
#size 3
#shockres 50
#weapon "sternhammer"
#poorleader
#okundeadleader
#startage 10
#maxage 900
#nametype 139
#end

-- Sturmheld

#newmonster 2312
#spr1 "./Ulm Reborn/Sturmheld.tga"
#spr2 "./Ulm Reborn/Sturmheld2.tga"
#name "Sturmheld"
#descr "The Sturmheld weild a power even greater than the righteous Sternheld. They are undead Ulmic angels of wrath and spite. Like the Sternheld they have one black and one white wing, representing the transitional state of their souls between the earth and the Aufklarung. Unlike the Sternheld they have no gift for astral magic, but are masters of air and lightning. Sternkind have been known to substantiate in areas of great faith just to follow the Sturmheld."
#undead
#domsummon20 2980
#holy
#hp 25
#str 13
#att 14
#def 12
#prot 9
#enc 3
#prec 12
#gcost 500
#flying
#mr 12
#magicskill 1 3
#magicskill 0 2
#mapmove 3
#ap 12
#mor 25
#size 3
#shockres 100
#weapon "sternhammer"
#goodleader
#goodundeadleader
#startage 10
#maxage 900
#nametype 139
#end


-------- New Heroes


-- Grey Shepherd

#newmonster 2983
#spr1 "./Ulm Reborn/Grey Shepherd.tga"
#spr2 "./Ulm Reborn/Grey Shepherd2.tga"
#name "Grey Shepherd"
#descr "The Grey Shepherd is a wandering priest of the Iron Faith who many call the Smith of Souls. It is said he can test the mettle of any man's soul at a glance and, given a few years, cleanse even the darkest native of Ulm from all flaws. The Grey Shepherd has never been heard to speak; he simply appears and with a single nod calls men to his flock. He attracts far more penitent than any other priest alive."
#str 12
#att 10
#def 12
#hp 16
#mapmove 2
#enc 2
#ap 12
#prec 11
#mr 14
#mor 19
#gcost 1
#rcost 1
#holy
#magicskill 8 3
#weapon "quarterstaff"
#domsummon "penitent"
#summon5 "penitent"
#expertleader
#nametype 139
#itemslots 31878
#end

-- Reborn Noble

#newmonster 2315
#spr1 "./Ulm Reborn/Reborn Noble.tga"
#spr2 "./Ulm Reborn/Reborn Noble2.tga"
#name "Reborn Noble"
#descr "This infamous nobleman was responsible for some of the most terrible atrocities of the Civil War; children slaughtered, women raped, entire towns put to the sword. Yet with the coming of the Aufklarung and the awakening god, the noble was reborn. All could see by the light in his eyes that he had changed, but the noble demanded to be tested, given the chance to prove his righteous rebirth. And so he was given up to the Black Temple to be 'tested', then to the White Temple to be purged, then finally to the Keep of the Reborn, to be trained. He emerged something more than a mere man and has become a leader of great standing, loved by the sons of the Iron Faith but feared and despised by their heathen foes."
#holy
#armor "whitesteel plate of ulm"
#weapon "great sword"
#ap 12
#enc 2
#mapmove 2
#att 14
#def 14
#hp 35
#str 15
#mor 20
#fear 2
#awe 2
#mr 13
#standard 20
#gcost 1
#rcost 1
#expertleader
#maxage 100
#nametype 104
#itemslots 31878
#end

-- Confessor

#newmonster 2316
#spr1 "./Ulm Reborn/Confessor.tga"
#spr2 "./Ulm Reborn/Confessor2.tga"
#copystats 2310
#name "Confessor"
#descr "The high ranking Black Priest known only as the Confessor was, in a former life, a member of the Marignese clergy. Leading a group of soldiers on a crusade into the tumultuous lands of Ulm during the Civil War, he and his band were struck with the ineffable power of the Aufklarung as strongly as any native of Ulm. He converted immediately to follow the new god and joined the Iron Faith. He has since become a powerful and influential figure in Ulm who has added his doctrine of cleansing fire to the redemption offered by the faith."
#clearmagic
#clearmagic
#clearmagic
#weapon "Absolver Hammer"
#itemslots 31878
#magicskill 0 2
#magicskill 8 2
#magicskill 3 2
#end



-------- New Pretender


-------- New Spells


--newspell
--name "Reward the Faithful"
--descr "Holy stardust cascades down from the spreading mantle of the Aufklarung to heal the wounds of a small number of loyal soldiers."
--school 7
--restricted 75
--fatiguecost 0
--researchlevel 0
--path 0 8
--pathlevel 0 1
--range 20
--aoe 1
--effect 13
--flightspr -1
--damage 20
--explspr 10002
--range 30
--precision 70
--nreff 1
--end

#newspell
#copyspell "Lightning Bolt"
#name "Punish the Unjust"
#descr "A crackling blast of holy lightning tears down from the spreading mantle of the Aufklarung and strikes one enemy of Ulm."
#school 7
#restricted 75
#researchlevel 0
#path 0 8
#fatiguecost 20
#pathlevel 0 2
#damage 10
#range 50
#precision 10
#nreff 1
#end

#newspell
#name "Messengers of the Aufklarung"
#descr "The White Priest performs a holy ritual under the mantle of the Aufklarung allowing eight souls of virtue from the Civil War to reform as Sternkind; representatives of the afterlife and messengers of the new faith. They will only follow a commanding Sternheld." 
#school 0
#restricted 75
#researchlevel 3
#path 0 4
#path 1 8
#pathlevel 0 1
#pathlevel 1 3
#effect 10001
#fatiguecost 1300
#damage 2980
#nreff 8
#end

#newspell
#name "Hand of the Aufklarung"
#descr "The prophet performs a holy ritual under the mantle of the Aufklarung which gives form to a single Sternheld, a sacred undead being skilled in air and astral magic." 
#school 0
#restricted 75
#researchlevel 4
#path 0 4
#path 1 8
#pathlevel 0 1
#pathlevel 1 3
#effect 10021
#fatiguecost 1400
#damage 2981
#nreff 1
#end


#newspell
#name "Wrath of the Aufklarung"
#descr "The prophet performs a holy ritual under the mantle of the Aufklarung which gives form to a single Sturmheld, a sacred undead being of considerable power highly skilled in air magic with some knowledge of the fiery arts." 
#school 0
#restricted 75
#researchlevel 5
#path 0 4
#path 1 8
#pathlevel 0 1
#pathlevel 1 3
#effect 10021
#fatiguecost 2000
#damage 2312
#nreff 1
#end



-- Hot fixes for blessing type spells taken from the Black Tome of Alsophocus mod by Doctor Praetorious

#selectspell "Blessing"
#spec 12632064
#end

#selectspell "Divine Blessing"
#spec 12615680
#end

#selectspell 105
#path 0 -1
#school -1
#end

#selectspell 109
#path 0 -1
#school -1
#end

#selectspell 112
#path 0 -1
#school -1
#end


-------- New sites

#newsite 990

#name "Keep of the Reborn"


#path 8
#level 0


#rarity 5
#homemon 2306
#homecom 2308
#end



#newsite 991
#name "White Temple"


#path 8
#gems 4 1
#level 0


#rarity 5

#homecom 2979
#homecom 2982
#end



#newsite 992
#name "Forge of the Faithful"
#path 3
#level 0


#rarity 5
#gems 3 2
#res 30
#end



#newsite 993
#name "Black Temple"
#path 8
#level 0
#rarity 5
#homecom 2311
#homemon 2305
#end


-------- New Namepools


-------- New nations



#selectnation 75
#clear
#name "New Ulm"
#epithet "Iron Faith Reborn"
#era 3
#brief "The malediction never occured. Instead the Civil War was ended by the Aufklarung (enlightenment), a miraculous event heralding the awakening of a new god."
#descr "The malediction never occured. Instead the Civil War was ended by the Aufklarung (enlightenment), a miraculous event heralding the awakening of a new god. The Iron Faith rules all aspects of society both temporal and spirtual under the leadership of those reborn in the Aufklarung. Their White Priests and Acolytes are unaffected by drain dominion."
#summary "Race: Humans. Military: Heavy infantry and cavalry, many sacreds including droves of penitent. Magic: Earth, Astral, access to Air. Priests: Strong, Some attract penitent."
#flag "./Ulm Reborn/flag.tga"
#templepic 9
#castleprod 25
#color 160 160 160


------- Add Soldiers

#addrecunit 2300 -- Infantry with hammer
#addrecunit 2301 -- Crossbow
#addrecunit 2302 -- Pike
#addrecunit 2304 -- Anchorite
#addrecunit 2303 -- Black Zweihander


------- Add leaders

#addreccom 2307 -- Captain Hammer
#addreccom 2309 -- Black Acolyte
#addreccom 2310 -- Black Priest
#addreccom 2314 -- White Acolyte


------- Province Defence

--Sets the units to be used in province defense.

#defcom1 2307 -- Captain Hammer
#defcom2 2309
 -- Black Acolyte
#defunit1 2300 -- Infantry with hammer
#defunit1b 2301 -- Crossbow 
#defunit2 2978 -- Penitent


--Sets how many of the units to appear per point.

#defmult1 10
#defmult1b 10
#defmult2 14

------- Hero Settings

#hero1 2983
#hero2 2315
#hero3 2316
#multihero1 2312

#idealcold 0
#startsite "Forge of the Faithful"
#startsite "Black Temple"
#startsite "Keep of the Reborn"
#startsite "White Temple"
#startfort 3
#swampfort 11
#farmfort 41
#forestfort 35
#mountainfort 9
#defaultfort 7


------- Starting units

#startcom 2307
#startunittype1 2300
#startunitnbrs1 10
#startunittype2 2301
#startunitnbrs2 10
#startscout 2309
#end
